import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/model/authorization/authorization_response_model.dart';
import 'package:viserpay_agent/data/model/global/response_model/response_model.dart';
import 'package:viserpay_agent/data/model/money_out/check_agent_response_model.dart';
import 'package:viserpay_agent/data/model/money_out/cash_out_response_model.dart';
import 'package:viserpay_agent/data/repo/cash_in/cash_in_repo.dart';
import 'package:viserpay_agent/view/components/snack_bar/show_custom_snackbar.dart';

class CashInController extends GetxController {
  CashInRepo cashInRepo;
  CashInController({required this.cashInRepo});

  bool isLoading = true;
  String currency = "";
  Wallets? selectedWallet = Wallets();
  String selectedOtp = "";
  String amount = "";
  String totalCharge = "";
  String payable = "";
  String minLimit = "";
  String maxLimit = "";

  CashInResponseModel model = CashInResponseModel();

  TextEditingController userController = TextEditingController();
  TextEditingController amountController = TextEditingController();

  changeUserNumber(String value) {
    userController.text = value;
    update();
  }

  List<String> otpTypeList = [];

  setOtpMethod(String? otp) {
    selectedOtp = otp ?? "";
    update();
  }

  loadData() async {
    currency = cashInRepo.apiClient.getCurrencyOrUsername(isCurrency: true);
    isLoading = true;
    update();

    ResponseModel responseModel = await cashInRepo.getCashoutData();

    otpTypeList.clear();
    amountController.text = "";
    userController.text = "";

    otpTypeList.insert(0, MyStrings.selectOtp);

    if (responseModel.statusCode == 200) {
      model = CashInResponseModel.fromJson(jsonDecode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == MyStrings.success.toLowerCase()) {
        List<String>? tempOtpList = model.data?.otpType ?? [];
        minLimit = Converter.formatNumber(model.data?.moneyOutCharge?.minLimit ?? "0.0");
        maxLimit = Converter.formatNumber(model.data?.moneyOutCharge?.maxLimit ?? "0.0");
        if (tempOtpList.isNotEmpty || tempOtpList.isNotEmpty) {
          otpTypeList.addAll(tempOtpList);
        }
        if (tempOtpList.isNotEmpty) {
          selectedOtp = otpTypeList[0];
          setOtpMethod(selectedOtp);
        }
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }

    isLoading = false;
    update();
  }

  bool submitLoading = false;
  Future<void> submitCashIn() async {
    submitLoading = true;
    update();

    String walletId = selectedWallet?.id.toString() ?? '';
    String amount = amountController.text;
    String otpType = selectedOtp.toLowerCase().toString();

    ResponseModel response = await cashInRepo.submitcashIn(walletId: walletId, amount: amount, user: userController.text.toString(), otpType: otpType);
    if (response.statusCode == 200) {
      AuthorizationResponseModel model = AuthorizationResponseModel.fromJson(jsonDecode(response.responseJson));
      if (model.status?.toLowerCase() == 'success') {
        String actionId = model.data?.actionId ?? '';
        clearData();
        if (actionId.isNotEmpty) {
          Get.toNamed(RouteHelper.otpScreen, arguments: [actionId, RouteHelper.bottomNavBar, otpType]);
        } else {
          CustomSnackBar.success(successList: model.message?.success ?? [MyStrings.requestSuccess]);
        }
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.requestFail]);
      }
    } else {
      CustomSnackBar.error(errorList: [response.message]);
    }

    submitLoading = false;
    update();
  }

  double mainAmount = 0;
  String charge = "";
  String payableText = '';

  void changeInfoWidget(double amount) {
    if (selectedWallet?.id.toString() == "-1") {
      return;
    }
    mainAmount = amount;
    double percent = double.tryParse(model.data?.moneyOutCharge?.percentCharge ?? "0") ?? 0;
    double percentCharge = (amount * percent) / 100;
    double temCharge = double.tryParse(model.data?.moneyOutCharge?.fixedCharge ?? "0") ?? 0;
    double totalCharge = percentCharge + temCharge;
    charge = '${Converter.formatNumber('$totalCharge')} $currency';
    double payable = totalCharge + amount;
    payableText = '$payable $currency';
    update();
  }

  bool hasUser = false;
  String validUser = "";
  String invalidUser = "";
  bool? isUserFound;
  Future<void> checkAgentFocus(bool hasFocus) async {
    hasUser = hasFocus;
    update();

    ResponseModel responseModel = await cashInRepo.checkUser(user: userController.text);
    if (responseModel.statusCode == 200) {
      CheckAgentResponseModel model = CheckAgentResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      if (model.status.toString().toLowerCase() == "success") {
        isUserFound = true;
        validUser = MyStrings.validUserMsg;
        update();
      } else {
        isUserFound = false;
        invalidUser = MyStrings.invalidUserMsg;
        update();
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }
  }

// clear data
  clearData() {
    userController.text = "";
    amountController.text = "";
    selectedWallet = null;
    selectedOtp = "";
    isUserFound = false;
    update();
  }
}
